/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx_util.h"
#include "mx__segment.h"
#include "mx__lib.h"
#  include "mx__partner.h"
#include "mx__endpoint.h"
#include "mx__request.h"

void
mx__self_copy(struct mx_endpoint *ep, union mx_request *sreq, union mx_request *rreq, void *unex_data)
{
  uint32_t xfer_len;

  xfer_len = MX_MIN(rreq->recv.r_length, rreq->recv.basic.status.msg_length);

  if (sreq) {
    mx__copy_between_segments(rreq->recv.segments,
			      rreq->recv.count,
			      rreq->recv.memory_context,
			      0,
			      sreq->send.segments,
			      sreq->send.count,
			      sreq->send.memory_context,
			      0,
			      xfer_len);
  } else {
    mx__copy_to_segments(rreq->recv.segments,
			 rreq->recv.count,
			 rreq->recv.memory_context,
			 0,
			 unex_data,
			 xfer_len);
  }

  mx__partner_to_addr(ep->myself, &rreq->recv.basic.status.source);
  rreq->recv.basic.status.xfer_length = xfer_len;
  mx__recv_complete(ep, rreq, MX_STATUS_SUCCESS);

  if (sreq) {
    sreq->send.basic.status.xfer_length = xfer_len;
    mx__send_complete(ep, sreq, MX_STATUS_SUCCESS);
  }
}


void mx__self_send(struct mx_endpoint *ep, union mx_request *q)
{
  uint64_t match_info = q->send.basic.status.match_info;
  uint32_t ctxid = CTXID_FROM_MATCHING(ep, match_info);
  union mx_request *rreq;
  uint32_t discard;
  void * data;
  q->send.basic.state = MX__REQUEST_STATE_PENDING;

  data = q->send.count == 1 ? q->send.segment.segment_ptr : NULL;
  /* do not try to pass the address of the destination buffer since it might be non-contiguous */
  rreq = mx__endpoint_match_receive(ep, ep->myself, match_info, 
				    q->send.basic.status.msg_length, data, &discard);
  if (discard) {
    /* this message has processed by the unexpected handler, do nothing else on the receiver's side */
    q->send.basic.status.xfer_length = rreq->recv.basic.status.msg_length;
    mx__send_complete(ep, q, MX_STATUS_SUCCESS);
  } else if (rreq) {
    /* rreq matched this message */
    mx__spliceout_request(&ep->ctxid[ctxid].recv_reqq, rreq);
    rreq->recv.basic.state |= MX__REQUEST_STATE_RECV_MATCHED;
    rreq->recv.basic.status.match_info = match_info;
    rreq->recv.basic.status.msg_length = q->send.basic.status.msg_length;
    mx__self_copy(ep, q, rreq, 0);
  } else {
    /* no receive matched, store the message as an unexpected */
    rreq = mx__rl_alloc(ep);
    if (rreq == NULL) {
      mx_fatal("mx__self_send:out of resources");
    }
    rreq->basic.partner = ep->myself;
    rreq->recv.segments = &rreq->recv.segment;
    rreq->recv.count = 1;
    rreq->recv.segment.segment_length = 0;
    rreq->recv.segment.segment_ptr = 0;
    rreq->recv.segments = &rreq->recv.segment;
    rreq->recv.basic.status.match_info = match_info;
    rreq->recv.basic.status.msg_length = q->send.basic.status.msg_length;
    rreq->recv.basic.status.xfer_length = q->send.basic.status.msg_length;
    rreq->recv.basic.type = MX__REQUEST_TYPE_RECV_SELF;
    rreq->recv.basic.wq = NULL;
    rreq->recv.unexpected = 1;
    mx__enqueue_request(&ep->ctxid[ctxid].unexpq, rreq);
    if (q->send.basic.type == MX__REQUEST_TYPE_SEND_LARGE) {
      rreq->recv.basic.state = MX__REQUEST_STATE_PENDING;
      rreq->recv.self_send_req = q;
      ep->sendself_count += 1;
    } else {
      rreq->recv.basic.state = MX__REQUEST_STATE_COMPLETED;
      rreq->recv.self_send_req = 0;
      if (q->send.basic.status.msg_length) {
	void *segment_ptr = mx_malloc(q->send.basic.status.msg_length);
	if (segment_ptr == NULL) {
	  mx_fatal("Warning: mx__self_send/unexp:mx_malloc failed");
	}
	rreq->recv.segment.segment_ptr = MX_VA_TO_SEGMENT_PTR(segment_ptr);
	rreq->recv.segment.segment_length = q->send.basic.status.msg_length;
	mx__copy_from_segments(segment_ptr, q->send.segments, q->send.count,
			       q->send.memory_context, 0, q->send.basic.status.msg_length);
      }
      rreq->recv.ordered_unexp_weight = 0;
      ep->unexp_queue_length += q->send.basic.status.msg_length;

      q->send.basic.status.xfer_length = q->send.basic.status.msg_length;
      mx__send_complete(ep, q, MX_STATUS_SUCCESS);
    }
  }
}
